#ifndef _LeakDetectorLogWriter_h__
#define _LeakDetectorLogWriter_h__

#include <buildspec.h>
#include <config.h>
#include <string>

namespace GST
{
namespace Utils
{

/**
Create me in the scope you want to detect leaks.

E.g. simple inside a method
	void testMe()
	{
		LeakDetectorLogWriter("leakdetect.log");

		//do some fancy stuff
	}

or if you want to detect leaks in whole program runtime, init me as global
static variable!

	static Utils::LeakDetectorLogWriter detector("leakdetect.log");
*/
class GST_API_EXPORT LeakDetectorLogWriter
{
public:
	std::string logFile;

	LeakDetectorLogWriter(const std::string &logfile);

	~LeakDetectorLogWriter();
};

} // namespace Utils
} // namespace GST

#endif // _LeakDetectorLogWriter_h__
